package de.mse.uebung6.aufgabe1;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Movie {

   int rank;
   float rating;
   String title;
   int year;
   int votes;

   public Movie(String s) {
      Pattern pattern = Pattern.compile("([0-9]*);([0-9\\.]*);(.*);([0-9]*);([0-9]*)");
      Matcher matcher = pattern.matcher(s);
      if (matcher.find()) {
         rank = Integer.parseInt(matcher.group(1));
         rating = Float.parseFloat(matcher.group(2));
         title = matcher.group(3);
         year = Integer.parseInt(matcher.group(4));
         votes = Integer.parseInt(matcher.group(5));
      }
   }

   public String toString() {
      return title + " (" + year + "), " + rating + "/10.0 (" + votes + " votes)";
   }

   public static List<Movie> readMoviesFromFile(String filename) {
      ArrayList<Movie> movies = new ArrayList<Movie>();
      try {
         String line = null;
         BufferedReader br = new BufferedReader(new FileReader(filename));
         while ((line = br.readLine()) != null) {
            Movie movie = new Movie(line);
            movies.add(movie);
         }
      } catch (FileNotFoundException e) {
         System.out.println("File not found: " + filename);
      } catch (IOException e) {
         System.out.println("I/O Exception occured while reading file: " + filename);
      }
      return movies;
   }
}